<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://www.mf.gov.pl/SENT/2017/12/08/SENT_330.xsd"
                xmlns:tp="http://www.mf.gov.pl/SENT/2017/12/08/STypes.xsd">
    <xsl:template match="ns1:SENT_330">
        <!-- TODO: Auto-generated template -->
        <html>
            <head>
              <script>
          //<![CDATA[
					// Module
				var languative;
				(function (languative) {
				    var phraseIdAttr = "data-phrase-id";

				    languative.ignoreTags = {
				        img: "<img />",
				        br: "<br />",
				        hr: "<hr />"
				    };

				    languative.dictonaries = {
				        html: {
				            _id: "en",
				            _name: "English"
				        },

				        pl: {
				            _id: "pl",
				            _name: "Polski - Polish"
				        },

				        en: {
				            _id: "en",
				            _name: "English"
				        }
				    };

				    languative.selectedDictionary = null;

				    function getDictionary(langKey) {
				        langKey = langKey.toLowerCase();
				        if (langKey in languative.dictonaries)
				            return languative.dictonaries[langKey];
				            else
				            return languative.dictonaries["pl"];

				        // Dictionary at key "pl-PL" not found, so keep looking for key "pl"
				        var sep = langKey.indexOf("-");
				        if (sep > 0)
				            langKey = langKey.substring(0, sep);
				        return languative.dictonaries[langKey];
				    }
				    languative.getDictionary = getDictionary;

				    function getPhrase(phraseId) {
				        var res = findPhrase(phraseId);
				        if (res)
				            return res; else
				            return phraseId;
				    }
				    languative.getPhrase = getPhrase;

				    function findPhrase(phraseId) {
				        if ((phraseId == null) || (phraseId == ""))
				            return null;

				        if ((languative.selectedDictionary != null) && (phraseId in languative.selectedDictionary))
				            return languative.selectedDictionary[phraseId];
				        if (phraseId in languative.dictonaries.html)
				            return languative.dictonaries.html[phraseId];

				        return null;
				    }
				    languative.findPhrase = findPhrase;

				    function getYesNo(value) {
				        if (value === undefined)
				            return getPhrase("undefined"); else if (value)
				            return getPhrase("yes"); else
				            return getPhrase("no");
				    }
				    languative.getYesNo = getYesNo;

				    //IE8 Tweak
				    function getAttr(node, attr) {
				        var result = (node.getAttribute && node.getAttribute(attr)) || null;
				        if (!result && node.attributes) {
				            for (var i = 0; i < node.attributes.length; i++) {
				                var attrNode = node.attributes[i];
				                if (attrNode.nodeName === attr)
				                    return attrNode.nodeValue;
				            }
				        }
				        return result;
				    }

				    function changeLanguage(langKey) {
				        function setTagPhrase(tag, phrase) {
				            if (tag.childNodes.length > 1) {
				                for (var ci = 0; ci < tag.childNodes.length; ci++) {
				                    var chNode = tag.childNodes[ci];
				                    var nName = chNode.nodeName.toLowerCase();
				                    if (!(nName in languative.ignoreTags)) {
				                        if ("innerHTML" in chNode) {
				                            chNode["innerHTML"] = " " + phrase[ci] + " ";
				                        } else {
				                            chNode.nodeValue = " " + phrase[ci] + " ";
				                        }
				                    }
				                }
				            } else {
				                tag.innerHTML = " " + phrase + " ";
				            }
				        }

				        //return;
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            console.warn("Cannot identify dictionary by key '" + langKey + "'. Default dictionary (" + languative.dictonaries.html._id + ": " + languative.dictonaries.html._name + ") used instead.");
				            langDict = languative.dictonaries.html;
				        }
				        languative.selectedDictionary = langDict;

				        var tags = getHtmlTags();
				        for (var ti = 0; ti < tags.length; ti++) {
				            var tag = tags[ti];
				            var phraseId = getAttr(tag, phraseIdAttr);
				            if ((phraseId != null)) {
				                var phraseValue = languative.getPhrase(phraseId);
				                if (phraseValue) {
				                    setTagPhrase(tag, phraseValue);
				                } else {
				                    console.warn("Phrase not definied in dictionary: data-phrase-id='" + phraseId + "'");
				                }
				            }
				        }

				        if (langDict["Title"] != null) {
				            document.title = langDict["Title"];
				        }
				    }
				    languative.changeLanguage = changeLanguage;

				    function getHtmlTags() {
				        var res = new Array();
				        var docTags = document.body.getElementsByTagName("*");

				        for (var i = 0; i < docTags.length; i++) {
				            var docTag = docTags[i];
				            var phraseId = getAttr(docTag, phraseIdAttr);
				            if (phraseId)
				                res.push(docTag);
				        }
				        return res;
				    }

				    var initialized = false;

				    function init() {
				        if (!initialized) {
				            initialized = true;
				            var htmlDict = languative.dictonaries.en;

				            for (var dictKey in htmlDict) {
				                if (!(dictKey in languative.dictonaries.html)) {
				                    languative.dictonaries.html[dictKey] = htmlDict[dictKey];
				                }
				            }
				            var nav = window.navigator;
				            languative.changeLanguage(nav.userLanguage || nav.language);
				        }
				    }
				    languative.init = init;

				    function modifyDictionary(langKey, dictModifications) {
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            languative.dictonaries[langKey.toLowerCase()] = dictModifications;
				        } else {
				            for (var dictKey in dictModifications) {
				                langDict[dictKey] = dictModifications[dictKey];
				            }
				        }
				    }
				    languative.modifyDictionary = modifyDictionary;
				})(languative || (languative = {}));

				if (document.addEventListener)
				    document.addEventListener('DOMContentLoaded', languative.init);

				if (window.addEventListener) {
				    window.addEventListener('load', languative.init, false);
				} else {
				    window.attachEvent('onload', languative.init);
				}
				<!-- sourceMappingURL=languative.js.map -->

				languative.modifyDictionary("html", {
            		githubLink: "Fork me on GitHub"
        		});
languative.modifyDictionary("pl", {
sent330: "SENT330 - REJESTRACJA ZBIORCZEGO ZGŁOSZENIA PRZEWOZU TOWARU ROZPOCZYNAJĄCEGO I KOŃCZĄCEGO SIĘ POZA TERYTORIUM POLSKI - PRZEWOŹNIK (TRANSPORT KOLEJOWY - WIELE WAGONÓW)",
selectLanguage: "Wybierz język:",
english: "English",
polish: "Polski",
sentTypeOfTransport: "Rodzaj transportu:",
sentTypeOfTransport1: "Drogowy",
sentTypeOfTransport2: "Kolejowy",
sentGoodsCarrierInfo: "Informacje o przewoźniku towaru",
sentBasicInfo: "Informacje podstawowe",
sentIdSisc: "Identyfikator idSISC:",
sentTraderName: "Pełna nazwa:",
sentTraderIdentityType: "Rodzaj identyfikatora:",
sentTraderIdentityNumber: "Numer identyfikatora:",
sentAdress: "Informacje adresowe",
sentGoodsSender200Info: "Informacje o nadawcy towaru",
sentGoodsRecipient300Info: "Informacje o odbiorcy towaru",
sentCommonGoodsInformation: "Informacje wspólne o towarze",
sentCodeCnClassification1: "Pozycja CN:",
sentWasteCode2: "Kod odpadu:",
sentTotalGrossWeightOfGoods: "Całkowita masa brutto lub objętość towaru:",
sentVATRate2: "Stawka VAT:",
sentGoodsTransportDocuments: "Informacje o dokumentach przewozowych",
sentTypeOfTransportDocument: "Rodzaj dokumentu przewozowego:",
sentNumberOfTransportDocument: "Numer dokumentu przewozowego:",
sentTransportMean: "Informacje o środku transportu",
sentLocomotiveNumber: "Numer pociągu:",
sentWagonNumber: "Numer wagonu:",
sentGoodsName: "Nazwa towaru",
sentGrossWeightOfGoods: "Masa brutto lub objętość towaru",
sentGoodsInfo: "Informacja o przewozie towaru",
sentEntranceToPoland: "Miejsce wjazdu na terytorium Polski",
sentRoutePlace: "Miejsce przekroczenia granicy:",
sentRouteNumber: "Numer drogi/toru:",
sentOtherPlace: "Inne miejsce:",
sentProvince: "Województwo:",
sentLatitude: "Szerokość geograficzna:",
sentLongitude: "Długość geograficzna:",
sentExitFromPoland: "Miejsce wyjazdu poza terytorium Polski",
sentStartCarriageDate: "Data faktycznego rozpoczęcia przewozu:",
sentEndPlannedTransportDate: "Planowana data zakończenia przewozu:",
sentAdditionalInfo: "Informacje dodatkowe",
sentSelfNumber: "Numer własny zgłoszenia:",
sentAdresses: "Kanały komunikacji zwrotnej",
sentEmail: "Adresy e-mail",
sentWebservice: "Kanał Web service",
sentWS: "Adres Web service zapisany w usłudze e-Klient:",
sentStatusYes: "Tak",
sentStatusNo: "Nie",
sentURL: "Adres URL:",
sentUserName: "Nazwa użytkownika:",
sentPassword: "Hasło:",
sentAuthenticationKey: "Odcisk palca certyfikatu:",
sentStatements: "Oświadczenia",
sentStatements1: "Oświadczam, że posiadam upoważnienie do złożenia niniejszego zgłoszenia w imieniu i na rzecz podmiotu zobowiązanego",
sentStatementsFullName: "Imię i nazwisko:",
sentTypeOfDeclaration: "Typ zgłoszenia:",
sentTypeOfDeclaration1: "Towary (z wyłączeniem paliw opałowych)",
sentTypeOfDeclaration2: "Paliwa opałowe",
sentTypeOfDeclaration3: "Gaz LPG",
sentComments: "Uwagi do zgłoszenia:"
});

languative.modifyDictionary("en", {
sent330: "SENT330 - REGISTRATION OF THE CUMULATIVE NOTIFICATION OF THE CARRIAGE OF GOODS STARTING AND ENDING OUTSIDE THE TERRITORY OF POLAND - THE CARRIER (RAILWAY TRANSPORT - MULTIPLE RAILROAD CARS)",
selectLanguage: "Select language:",
english: "English",
polish: "Polski",
sentTypeOfTransport: "Type of transport:",
sentTypeOfTransport1: "Road",
sentTypeOfTransport2: "Railway",
sentGoodsCarrierInfo: "Information on the carrier of goods",
sentBasicInfo: "Basic information",
sentIdSisc: "idSISC identification number:",
sentTraderName: "Full name:",
sentTraderIdentityType: "Identification type:",
sentTraderIdentityNumber: "Identification number:",
sentAdress: "Address information",
sentGoodsSender200Info: "Information on the consignor of the goods",
sentGoodsRecipient300Info: "Information on the recipient of the goods",
sentCommonGoodsInformation: "Common information about the goods",
sentCodeCnClassification1: "CN items:",
sentWasteCode2: "Waste code:",
sentTotalGrossWeightOfGoods: "Total gross weight or volume of goods",
sentVATRate2: "VAT Rate:",
sentGoodsTransportDocuments: "Information on transport documents",
sentTypeOfTransportDocument: "Type of transport document:",
sentNumberOfTransportDocument: "Number of transport document:",
sentTransportMean: "Information on the means of transport",
sentLocomotiveNumber: "Train number:",
sentWagonNumber: "Railroad car number:",
sentGoodsName: "Name of the goods",
sentGrossWeightOfGoods: "Gross weight or volume of goods",
sentGoodsInfo: "Information on the goods carriage",
sentEntranceToPoland: "Place of entry to Poland",
sentRoutePlace: "Place of border crossing:",
sentRouteNumber: "Route/track number:",
sentOtherPlace: "Other place:",
sentProvince: "Province:",
sentLatitude: "Latitude:",
sentLongitude: "Longitude:",
sentExitFromPoland: "Place of exit from Poland",
sentStartCarriageDate: "Actual start date of the carriage:",
sentEndPlannedTransportDate: "Planned end date of the carriage:",
sentAdditionalInfo: "Additional information",
sentSelfNumber: "Own number of the notification:",
sentAdresses: "Feedback communication channel",
sentEmail: "E-mail addresses",
sentWebservice: "Web service channel",
sentWS: "Web service address which is indicated in the e-Client service:",
sentStatusYes: "Yes",
sentStatusNo: "No",
sentURL: "URL address:",
sentUserName: "User Name:",
sentPassword: "Password:",
sentAuthenticationKey: "Fingerprint of certificate:",
sentStatements: "Declarations",
sentStatements1: "I declare that I am authorized to submit this notification for and on behalf of the obligated entity",
sentStatementsFullName: "Full Name:",
sentTypeOfDeclaration: "Type of the notification:",
sentTypeOfDeclaration1: "Goods (excluding heating fuels)",
sentTypeOfDeclaration2: "Heating fuels",
sentTypeOfDeclaration3: "LPG gas",
sentComments: "Comments to the notification:"
});


function loadHtmlDictionary() {
document.getElementById("htmlDictionary").innerText = JSON.stringify(languative.dictonaries.html, null, "  ");
}

function loadActiveDictionary() {
document.getElementById("activeDictionary").innerText = JSON.stringify(languative.getDictionaryFromHtml(), null, "  ");
}


//]]>
                </script>
              <style>
                * {
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
                }

                @media print {
                body {-webkit-print-color-adjust: exact;}
                }

                body {
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                margin: 0 auto;
                padding: 0 auto;
                }

                .sent-xslt {
                border-collapse: initial;
                }

                .sent-xslt h1 {
                padding: 6px 4px 4px 10px;
                color:#000000;
                margin-top: 0;
                background-color:#c5c2c2;
                font-weight: normal;
                font-size: 12px;
                margin-bottom: 0;
                border-bottom: 1px solid #c8c9ca;
                }

                .sent-xslt .s1 {
                max-width: 1220px;
                border: 1px solid #c8c9ca;
                }

                .sent-xslt .t1 {
                position: relative;
                display: table;
                width: 100%;
                }

                .sent-xslt .t2 {
                padding: 15px 5px 3px 5px;
                border: 1px solid;
                margin: 0 10px 20px 10px;
                }

                .sent-xslt .t3 {
                padding: 15px 5px 3px 5px;
                border: 1px solid red;
                margin: 0 10px 20px 10px;
                }

                .sent-xslt .grupName {
                font-size: 12px;
                margin: 0 !important;
                font-weight: bold;
                display:block;
                color: #000000;
                background-color:#dbddde;
                padding:5px 5px 5px 10px;
                border-top: 1px solid #dbddde;
                }

                .sent-xslt .grupNameRed {
                font-size: 14px;
                margin: -15px -5px 0 -5px;
                font-weight: bold;
                display:block;
                color: #000000;
                background-color:red;
                padding:5px 5px 5px 10px;
                border: 1px solid red;
                }

                .sent-xslt .element-1 {
                font-size: 12px;
                font-weight: normal;
                }

                .sent-xslt .element-2 {
                font-size: 14px;
                font-weight: normal;
                color: #008540;
                }

                .sent-xslt .green {
                background-color: #DAFFCC;
                height: 35px;
                padding-top: 4px;
                }

                .sent-xslt .green-key {
                background-color: #DAFFCC;
                padding: 7px 0px !important;
                }

                .sent-xslt .element-3 {
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                font-size: 12px;
                font-weight: normal;
                border-spacing: 10 10;
                white-space: pre-wrap; /* Since CSS 2.1 */
                white-space: -moz-pre-wrap; /* Mozilla, since 1999 */
                white-space: -pre-wrap; /* Opera 4-6 */
                white-space: -o-pre-wrap; /* Opera 7 */
                word-wrap: break-word; /* Internet Explorer 5.5+ */
                word-break: normal;
                }
                
                .sent-xslt .grupInfo p {
                margin: 1px 0 1px 10px;
                font-weight: bold;
                font-size: 12px;
                }

                .sent-xslt .grupInfo {
                border-top: 1px solid #dbddde;
                }

                .sent-xslt .grupInfoSent {
                min-height: 40px;
                }

                .sent-xslt .grupInfoSent p {
                margin: -2px 0 1px 10px;
                font-size: 16px;
                font-weight: bold;
                }

                .sent-xslt .oilstatus {
                margin: 0 5px 0 -5px;
                margin: 2px 0 1px 10px;
                font-size: 14px;
                padding-bottom: 12px;
                color: red;
                }

                .sent-xslt .info {
                width: 100%;
                float: left;
                display: table-cell;
                padding: 4px 0px;
                }

                .sent-xslt .info1 {
                width: 50%;
                float: left;
                display: table-cell;
                padding: 4px 0px;
                }

                .sent-xslt .info3 {
                width: 33%;
                float: left;
                display: table-cell;
                }

                .sent-xslt .lang ul {
                margin: 0 auto;
                padding: 0;
                }

                .sent-xslt .lang ul li {
                display: inline;
                margin-left: 10px;
                }

                .sent-xslt .table {
                display: table;
                width: 99%;
                margin: 4px 0 15px 7px;
                border-spacing: 0 0;
                border-top: 1px solid #999999;
                border-left: 1px solid #999999;
                }

                .sent-xslt .table-header {
                font-size: 10px;
                font-weight: bold;
                padding: 5px;
                background-color: #ececec;
                border-bottom: 1px solid #999999;
                border-right: 1px solid #999999;
                }

                .sent-xslt .table-element {
                font-size: 12px;
                font-weight: normal;
                padding: 2px 5px;
                border-bottom: 1px solid #999999;
                border-right: 1px solid #999999;
                }

                .sent-xslt .table-element2 {
                font-size: 12px;
                font-weight: normal;
                padding: 0;
                }

                .sent-xslt .table-element3 {
                font-size: 12px;
                font-weight: bold;
                border: 1px #999999;
                border-top-style: solid;
                margin: 0;
                }

                .sent-xslt .table-element p {
                margin-left: 0;
                }

                .sent-xslt .table-element2 p {
                margin-left: 0;
                }

                .sent-xslt .table-element3 p {
                margin-left: 0;
                padding: 0px 5px;
                }

              </style>
            </head>
          <body>
            <div class="sent-xslt">
              <section class="sent-xslt s1">
                <div class="sent-xslt lang">
                  <ul>
                    <li>
                      <span class="sent-xslt element-1" data-phrase-id="selectLanguage"></span>
                    </li>
                    <li>
                      <span class="sent-xslt element-1">
                        <a href="#" onclick="languative.changeLanguage('en');">
                          <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAB6ElEQVQoz2OYNHPfjqtvqqcfS2kGosOJjQdu3n27NrlxTUIdkOGZvc0jbYdtzIaoxp1zAvOr5x5lWLLi1P+Nq/79+3/74ZdFG27PX38HyP4/ped/XyuQMWnh5d65F06eePyvq+bf358TNl1gSGo5uOfku/9Ll/8/uPf///9t064Cyf+pmf8TEoF0Sd+lL4vWfO/uBrLnrbokaTIDpGHhhrt1E68+3Hf/T1P9fwiIifkfHgFi5Gb+f/Hiwp23jp7Li5qOCOpOZAA6FOQGNBAa+t/PD00MqOzMtZcMaxJr/0/u+J+S8j8+/n9k5P+QEJBSH59/rq6/7O1/Wlp+NzH5qqf3VVv7Z7Bbq7wVDhtsbf+YWUDMBeK/f//++fvn958/J6++YLCP29Qz53xU2o4rV9//f/vmZ3I8SJWRyW99Q7CGv0+dHPfP3CohPSskYT2DcDaDedi6xetBIfO5se5DV1dMyTEg+4+27i9NbaCrreyX/Pz//8usuS8SYpqmnmMQTGeYvPnyv39/v7dXHD1wu7DhYF7DYaAL/4Z4/A5y/vf3b3jattC41dsP3/r758frBN/soiUMVfMOTHFJds5cJKgzh0djMofqhPPXXrRKW7SIm5y+8pJBvJhBtIBBOFfEsK53z3VX0zwAPExoqi63l4YAAAAASUVORK5CYII='/>
                        </a>
                      </span>
                    </li>
                    <li>
                      <span class="sent-xslt element-1">
                        <a href="#" onclick="languative.changeLanguage('pl');">
                          <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAMAAABBPP0LAAAAhFBMVEXDAADKAADVAQHX19faAADd3d3jDQ3k5eXlExPmGRnnLi7oHx/oMjLoNjbpJCTqKirq6urrLi7sLy/sOzrsRETtNDTtS0vuUFDu7u7vi4vvmZnwVlfwj4/xlJTy8vL0m5v19fX29vb39/f4+Pj5+fn6+vr7+/v8/Pz9/f39/f7+/v7///9BfFeGAAAAXUlEQVQIHQXB0W1CMRRAMecRpI7BZ/dfiRWQqBC5p/Z6wPDhz5t1+xWVqp4bq1FVLRuWqioucKuqNPu8AKNjtb3AdU5nuncB1zmdSTa4vtOZxrT94Hsf+TQstkEQ/8uqTs/uhVeSAAAAAElFTkSuQmCC'/>
                        </a>
                      </span>
                    </li>
                  </ul>
                </div>
                <h1 data-phrase-id="sent330"></h1>
                <div class="sent-xslt t1">
                  <div class="sent-xslt grupInfo">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTypeOfTransport"></span>
                        <xsl:choose>
                          <xsl:when test="ns1:TypeOfTransport = '1'">
                            <span data-phrase-id="sentTypeOfTransport1"></span>
                          </xsl:when>
                          <xsl:when test="ns1:TypeOfTransport = '2'">
                            <span data-phrase-id="sentTypeOfTransport2"></span>
                          </xsl:when>
                        </xsl:choose>
                      </p>
                    </div>
                    <xsl:if test="ns1:TypeOfDeclaration != ''">
                      <div class="sent-xslt info1">
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentTypeOfDeclaration"></span>
                          <xsl:choose>
                            <xsl:when test="ns1:TypeOfDeclaration = '1'">
                              <span data-phrase-id="sentTypeOfDeclaration1"></span>
                            </xsl:when>
                            <xsl:when test="ns1:TypeOfDeclaration = '2'">
                              <span data-phrase-id="sentTypeOfDeclaration2"></span>
                            </xsl:when>
                            <xsl:when test="ns1:TypeOfDeclaration = '3'">
                              <span data-phrase-id="sentTypeOfDeclaration3"></span>
                            </xsl:when>
                          </xsl:choose>
                        </p>
                      </div>
                    </xsl:if>
                  </div>
                </div>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentGoodsCarrierInfo"></p>
                  <div class="sent-xslt grupInfo">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-2" data-phrase-id="sentBasicInfo"></span>
                      </p>
                      <xsl:if test="ns1:Carrier/tp:TraderInfo/tp:IdSisc !=''">
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentIdSisc"></span>
                          <xsl:value-of select="ns1:Carrier/tp:TraderInfo/tp:IdSisc"/>
                        </p>
                      </xsl:if>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderName"></span>
                        <xsl:value-of select="ns1:Carrier/tp:TraderInfo/tp:TraderName"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityType"></span>
                        <xsl:value-of select="ns1:Carrier/tp:TraderInfo/tp:TraderIdentityType"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityNumber"></span>
                        <xsl:value-of select="ns1:Carrier/tp:TraderInfo/tp:TraderIdentityNumber"/>
                      </p>
                    </div>
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-2" data-phrase-id="sentAdress"></span>
                      </p>
                      <xsl:variable name="ulica">
                        <xsl:choose>
                          <xsl:when test="ns1:Carrier/tp:TraderAddress/tp:FlatNumber != ''">
                            <p>
                              <xsl:value-of select="ns1:Carrier/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:Carrier/tp:TraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of select="ns1:Carrier/tp:TraderAddress/tp:FlatNumber"/>
                            </p>
                          </xsl:when>
                          <xsl:otherwise>
                            <p>
                              <xsl:value-of select="ns1:Carrier/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:Carrier/tp:TraderAddress/tp:HouseNumber"/>
                            </p>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>
                      <p>
                        <xsl:value-of select="$ulica"/>
                      </p>
                      <p>
                        <xsl:value-of select="ns1:Carrier/tp:TraderAddress/tp:PostalCode"/><xsl:text>&#160;</xsl:text>
                        <xsl:value-of select="ns1:Carrier/tp:TraderAddress/tp:City"/>
                        <xsl:if test="ns1:Carrier/tp:TraderAddress/tp:City != ''">,</xsl:if>
                        <xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:Carrier/tp:TraderAddress/tp:Country"/>
                      </p>
                    </div>
                  </div>
                </div>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentGoodsSender200Info"></p>
                  <div class="sent-xslt grupInfo">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-2" data-phrase-id="sentBasicInfo"></span>
                      </p>
                      <xsl:if test="ns1:GoodsSender/tp:TraderInfo/tp:IdSisc !=''">
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentIdSisc"></span>
                          <xsl:value-of select="ns1:GoodsSender/tp:TraderInfo/tp:IdSisc"/>
                        </p>
                      </xsl:if>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderName"></span>
                        <xsl:value-of select="ns1:GoodsSender/tp:TraderInfo/tp:TraderName"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityType"></span>
                        <xsl:value-of select="ns1:GoodsSender/tp:TraderInfo/tp:TraderIdentityType"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityNumber"></span>
                        <xsl:value-of select="ns1:GoodsSender/tp:TraderInfo/tp:TraderIdentityNumber"/>
                      </p>
                    </div>
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-2" data-phrase-id="sentAdress"></span>
                      </p>
                      <xsl:variable name="ulica">
                        <xsl:choose>
                          <xsl:when test="ns1:GoodsSender/tp:TraderAddress/tp:FlatNumber != ''">
                            <p>
                              <xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:FlatNumber"/>
                            </p>
                          </xsl:when>
                          <xsl:otherwise>
                            <p>
                              <xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:HouseNumber"/>
                            </p>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>
                      <p>
                        <xsl:value-of select="$ulica"/>
                      </p>
                      <p>
                        <xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:PostalCode"/><xsl:text>&#160;</xsl:text>
                        <xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:City"/>
                        <xsl:if test="ns1:GoodsSender/tp:TraderAddress/tp:City != ''">,</xsl:if>
                        <xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:Country"/>
                      </p>
                    </div>
                  </div>
                </div>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentGoodsRecipient300Info"></p>
                  <div class="sent-xslt grupInfo">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-2" data-phrase-id="sentBasicInfo"></span>
                      </p>
                      <xsl:if test="ns1:GoodsRecipient/tp:TraderInfo/tp:IdSisc !=''">
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentIdSisc"></span>
                          <xsl:value-of select="ns1:GoodsRecipient/tp:TraderInfo/tp:IdSisc"/>
                        </p>
                      </xsl:if>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderName"></span>
                        <xsl:value-of select="ns1:GoodsRecipient/tp:TraderInfo/tp:TraderName"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityType"></span>
                        <xsl:value-of select="ns1:GoodsRecipient/tp:TraderInfo/tp:TraderIdentityType"/>
                      </p>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityNumber"></span>
                        <xsl:value-of select="ns1:GoodsRecipient/tp:TraderInfo/tp:TraderIdentityNumber"/>
                      </p>
                    </div>
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-2" data-phrase-id="sentAdress"></span>
                      </p>
                      <xsl:variable name="ulica">
                        <xsl:choose>
                          <xsl:when test="ns1:GoodsRecipient/tp:TraderAddress/tp:FlatNumber != ''">
                            <p>
                              <xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:FlatNumber"/>
                            </p>
                          </xsl:when>
                          <xsl:otherwise>
                            <p>
                              <xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:HouseNumber"/>
                            </p>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>
                      <p>
                        <xsl:value-of select="$ulica"/>
                      </p>
                      <p>
                        <xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:PostalCode"/><xsl:text>&#160;</xsl:text>
                        <xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:City"/>
                        <xsl:if test="ns1:GoodsRecipient/tp:TraderAddress/tp:City != ''">,</xsl:if>
                        <xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:Country"/>
                      </p>
                    </div>
                  </div>
                </div>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentCommonGoodsInformation"></p>
                  <div class="sent-xslt grupInfo">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentCodeCnClassification1"></span>
                        <xsl:value-of select="ns1:CommonGoodsInformation/ns1:CodeCnClassification"/>
                      </p>
                      <xsl:if test="ns1:CommonGoodsInformation/ns1:WasteCode != ''">
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentWasteCode2"></span>
                          <xsl:value-of select="ns1:CommonGoodsInformation/ns1:WasteCode"/>
                        </p>
                      </xsl:if>
                    </div>
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTotalGrossWeightOfGoods"></span>
                        <xsl:value-of select="ns1:CommonGoodsInformation/ns1:TotalAmountOfGoods"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:CommonGoodsInformation/ns1:UnitOfMeasure"/>
                      </p>
                      <xsl:if test="ns1:CommonGoodsInformation/ns1:VATRate != ''">
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentVATRate2"></span>
                          <xsl:value-of select="ns1:CommonGoodsInformation/ns1:VATRate"/>
                          <xsl:if test="ns1:CommonGoodsInformation/ns1:VATRate != 'NP'">%</xsl:if>
                        </p>
                      </xsl:if>
                    </div>
                  </div>
                </div>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentGoodsTransportDocuments"></p>
                  <div class="sent-xslt grupInfo">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentTypeOfTransportDocument"></span>
                        <xsl:value-of select="ns1:GoodsTransportDocuments/tp:TypeOfTransportDocument"/>
                      </p>
                    </div>
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentNumberOfTransportDocument"></span>
                        <xsl:value-of select="ns1:GoodsTransportDocuments/tp:NumberOfTransportDocument"/>
                      </p>
                    </div>
                  </div>
                </div>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentTransportMean"></p>
                  <div class="sent-xslt grupInfo">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentLocomotiveNumber"></span>
                      <xsl:value-of select="ns1:MeansOfTransport/ns1:TrainNumber"/>
                    </p>
                  </div>
                  <div class="sent-xslt grupInfo0">
                    <table class="sent-xslt table">
                      <tr>
                        <td class="sent-xslt table-header" data-phrase-id="sentWagonNumber" style='width: 15%'></td>
                        <td class="sent-xslt table-header" data-phrase-id="sentGoodsName" style='width: 76%'></td>
                        <td class="sent-xslt table-header" data-phrase-id="sentGrossWeightOfGoods" style='width: 9%'></td>
                      </tr>
                      <xsl:variable name="UnitOfMeasure">
                        <xsl:value-of select="ns1:CommonGoodsInformation/ns1:UnitOfMeasure"/>
                      </xsl:variable>
                      <xsl:for-each select="ns1:MeansOfTransport/ns1:WagonNumberAndAmountOfGoods">
                        <tr>
                          <td class="sent-xslt table-element">
                            <xsl:value-of select="tp:WagonNumber"/>
                          </td>
                          <td class="sent-xslt table-element">
                            <xsl:value-of select="tp:GoodsName"/>
                          </td>
                          <td class="sent-xslt table-element">
                            <xsl:value-of select="tp:AmountOfGoods"/>
                            <xsl:text>&#160;</xsl:text><xsl:value-of select="$UnitOfMeasure"/>
                          </td>
                        </tr>
                      </xsl:for-each>
                    </table>
                  </div>
                </div>
                <xsl:if test="ns1:Transport/ns1:EntranceToPoland/tp:RoutePlace != ''">
                  <div class="sent-xslt t1">
                    <p class="sent-xslt grupName" data-phrase-id="sentGoodsInfo"></p>
                    <div class="sent-xslt grupInfo">
                      <div class="sent-xslt info1">
                        <p>
                          <span class="sent-xslt element-2" data-phrase-id="sentEntranceToPoland"></span>
                        </p>
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentRoutePlace"></span>
                          <xsl:value-of select="ns1:Transport/ns1:EntranceToPoland/tp:RoutePlace"/>
                        </p>
                      </div>
                      <div class="sent-xslt info1">
                        <br/>
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentRouteNumber"></span>
                          <xsl:value-of select="ns1:Transport/ns1:EntranceToPoland/tp:RouteNumber"/>
                        </p>
                      </div>
                    </div>
                  </div>
                </xsl:if>
                <xsl:if test="ns1:Transport/ns1:EntranceToPoland/tp:OtherPlace != ''">
                  <div class="sent-xslt t1">
                    <div class="sent-xslt grupInfo">
                      <div class="sent-xslt info1">
                        <p>
                          <span class="sent-xslt element-2" data-phrase-id="sentEntranceToPoland"></span>
                        </p>
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentOtherPlace"></span>
                          <xsl:value-of select="ns1:Transport/ns1:EntranceToPoland/tp:OtherPlace"/>
                        </p>
                        <xsl:if test="ns1:Transport/ns1:EntranceToPoland/tp:Province != ''">
                          <p>
                            <span class="sent-xslt element-1" data-phrase-id="sentProvince"></span>
                            <xsl:choose>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '02'">dolnośląskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '04'">kujawsko-pomorskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '06'">lubelskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '08'">lubuskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '10'">łódzkie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '12'">małopolskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '14'">mazowieckie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '16'">opolskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '18'">podkarpackie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '20'">podlaskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '22'">pomorskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '24'">śląskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '26'">świętokrzyskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '28'">warmińsko-mazurskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '30'">wielkopolskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:EntranceToPoland/tp:Province, 1,2) = '32'">zachodniopomorskie</xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="ns1:Transport/ns1:EntranceToPoland/tp:Province"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </p>
                        </xsl:if>
                      </div>
                      <div class="sent-xslt info1">
                        <br/>
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentLatitude"></span>
                          <xsl:value-of select="ns1:Transport/ns1:EntranceToPoland/tp:Latitude"/>
                        </p>
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentLongitude"></span>
                          <xsl:value-of select="ns1:Transport/ns1:EntranceToPoland/tp:Longitude"/>
                        </p>
                      </div>
                    </div>
                  </div>
                </xsl:if>
                <xsl:if test="ns1:Transport/ns1:ExitFromPoland/tp:RoutePlace != ''">
                  <div class="sent-xslt t1">
                    <div class="sent-xslt grupInfo">
                      <div class="sent-xslt info1">
                        <p>
                          <span class="sent-xslt element-2" data-phrase-id="sentExitFromPoland"></span>
                        </p>
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentRoutePlace"></span>
                          <xsl:value-of select="ns1:Transport/ns1:ExitFromPoland/tp:RoutePlace"/>
                        </p>
                      </div>
                      <div class="sent-xslt info1">
                        <br/>
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentRouteNumber"></span>
                          <xsl:value-of select="ns1:Transport/ns1:ExitFromPoland/tp:RouteNumber"/>
                        </p>
                      </div>
                    </div>
                  </div>
                </xsl:if>
                <xsl:if test="ns1:Transport/ns1:ExitFromPoland/tp:OtherPlace != ''">
                  <div class="sent-xslt t1">
                    <div class="sent-xslt grupInfo">
                      <div class="sent-xslt info1">
                        <p>
                          <span class="sent-xslt element-2" data-phrase-id="sentExitFromPoland"></span>
                        </p>
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentOtherPlace"></span>
                          <xsl:value-of select="ns1:Transport/ns1:ExitFromPoland/tp:OtherPlace"/>
                        </p>
                        <xsl:if test="ns1:Transport/ns1:ExitFromPoland/tp:Province != ''">
                          <p>
                            <span class="sent-xslt element-1" data-phrase-id="sentProvince"></span>
                            <xsl:choose>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '02'">dolnośląskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '04'">kujawsko-pomorskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '06'">lubelskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '08'">lubuskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '10'">łódzkie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '12'">małopolskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '14'">mazowieckie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '16'">opolskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '18'">podkarpackie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '20'">podlaskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '22'">pomorskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '24'">śląskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '26'">świętokrzyskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '28'">warmińsko-mazurskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '30'">wielkopolskie</xsl:when>
                              <xsl:when test="substring(ns1:Transport/ns1:ExitFromPoland/tp:Province, 1,2) = '32'">zachodniopomorskie</xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="ns1:Transport/ns1:ExitFromPoland/tp:Province"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </p>
                        </xsl:if>
                      </div>
                      <div class="sent-xslt info1">
                        <br/>
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentLatitude"></span>
                          <xsl:value-of select="ns1:Transport/ns1:ExitFromPoland/tp:Latitude"/>
                        </p>
                        <p>
                          <span class="sent-xslt element-1" data-phrase-id="sentLongitude"></span>
                          <xsl:value-of select="ns1:Transport/ns1:ExitFromPoland/tp:Longitude"/>
                        </p>
                      </div>
                    </div>
                  </div>
                </xsl:if>
                <div class="sent-xslt t1">
                  <div class="sent-xslt grupInfo">
                    <div class="sent-xslt info1">
                      <xsl:variable name="startCarriageDate">
                        <xsl:choose>
                          <xsl:when test="string-length(ns1:Transport/ns1:StartTransportDate) > 10">
                            <xsl:value-of select="substring-before(ns1:Transport/ns1:StartTransportDate, '+')"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="ns1:Transport/ns1:StartTransportDate"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentStartCarriageDate"></span>
                        <xsl:value-of select="$startCarriageDate"/>
                      </p>
                    </div>
                    <div class="sent-xslt info1">
                      <xsl:variable name="endPlannedTransportDate">
                        <xsl:choose>
                          <xsl:when test="string-length(ns1:Transport/ns1:EndTransportDate) > 10">
                            <xsl:value-of select="substring-before(ns1:Transport/ns1:EndTransportDate, '+')"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="ns1:Transport/ns1:EndTransportDate"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentEndPlannedTransportDate"></span>
                        <xsl:value-of select="$endPlannedTransportDate"/>
                      </p>
                    </div>
                  </div>
                </div>
                <xsl:if test="((ns1:Comments != '') or (ns1:DocumentId != ''))">
                  <div class="sent-xslt t1">
                    <p class="sent-xslt grupName" data-phrase-id="sentAdditionalInfo"></p>
                    <xsl:if test="ns1:Comments != ''">
                      <div class="sent-xslt t1">
                        <div class="sent-xslt grupInfo">
                          <div class="sent-xslt info">
                            <p>
                              <span class="sent-xslt element-1" data-phrase-id="sentComments"></span>
                              <xsl:value-of select="ns1:Comments"/>
                            </p>
                          </div>
                        </div>
                      </div>
                    </xsl:if>
                    <xsl:if test="ns1:DocumentId != ''">
                      <div class="sent-xslt t1">
                        <div class="sent-xslt grupInfo">
                          <div class="sent-xslt info">
                            <p>
                              <span class="sent-xslt element-1" data-phrase-id="sentSelfNumber"></span>
                              <xsl:value-of select="ns1:DocumentId"/>
                            </p>
                          </div>
                        </div>
                      </div>
                    </xsl:if>
                  </div>
                </xsl:if>
                <xsl:if test="ns1:ResponseAddress != ''">
                  <div class="sent-xslt t1">
                    <p class="sent-xslt grupName" data-phrase-id="sentAdresses"></p>
                    <div class="sent-xslt grupInfo">
                      <xsl:if test="ns1:ResponseAddress/tp:EmailChannel != ''">
                        <div class="sent-xslt info1">
                          <p>
                            <span class="sent-xslt element-2" data-phrase-id="sentEmail"></span>
                          </p>
                          <xsl:if test="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress1 != ''">
                            <p>
                              <xsl:value-of select="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress1"/>
                            </p>
                          </xsl:if>
                          <xsl:if test="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress2 != ''">
                            <p>
                              <xsl:value-of select="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress2"/>
                            </p>
                          </xsl:if>
                          <xsl:if test="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress3 != ''">
                            <p>
                              <xsl:value-of select="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress3"/>
                            </p>
                          </xsl:if>
                        </div>
                      </xsl:if>
                      <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel != ''">
                        <div class="sent-xslt info1">
                          <p>
                            <span class="sent-xslt element-2" data-phrase-id="sentWebservice"></span>
                          </p>
                          <p>
                            <span class="sent-xslt element-1" data-phrase-id="sentWS"></span>
                            <span>
                              <xsl:choose>
                                <xsl:when test="ns1:ResponseAddress/tp:WebServiceChannel/tp:WsFromSISC = 'true'">
                                  <span data-phrase-id="sentStatusYes"></span>
                                </xsl:when>
                                <xsl:when test="ns1:ResponseAddress/tp:WebServiceChannel/tp:WsFromSISC = 'false'">
                                  <span data-phrase-id="sentStatusNo"></span>
                                </xsl:when>
                              </xsl:choose>
                            </span>
                          </p>
                          <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:UrlAddress != ''">
                            <p>
                              <span class="sent-xslt element-1" data-phrase-id="sentURL"></span>
                              <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:UrlAddress"/>
                            </p>
                          </xsl:if>
                          <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:Username != ''">
                            <p>
                              <span class="sent-xslt element-1" data-phrase-id="sentUserName"></span>
                              <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:Username"/>
                            </p>
                          </xsl:if>
                          <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:UserPassword != ''">
                            <p>
                              <span class="sent-xslt element-1" data-phrase-id="sentPassword"></span>
                              <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:UserPassword"/>
                            </p>
                          </xsl:if>
                          <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:AuthenticationKey != ''">
                            <p>
                              <span class="sent-xslt element-1" data-phrase-id="sentAuthenticationKey"></span>
                              <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:AuthenticationKey"/>
                            </p>
                          </xsl:if>
                        </div>
                      </xsl:if>
                    </div>
                  </div>
                </xsl:if>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentStatements"></p>
                  <div class="sent-xslt grupInfo">
                    <p>
                      <xsl:choose>
                        <xsl:when test="ns1:Statements/tp:Statement1 = 'true'">
                          <input type="checkbox" onclick="return false;" checked=""/>
                          <span class="sent-xslt element-1" data-phrase-id="sentStatements1"></span>
                        </xsl:when>
                        <xsl:when test="ns1:Statements/tp:Statement1 = 'false'">
                          <input type="checkbox" onclick="return false;"/>
                          <span class="sent-xslt element-1" data-phrase-id="sentStatements1"></span>
                        </xsl:when>
                      </xsl:choose>
                    </p>
                    <p style="padding: 5px">
                      <span class="sent-xslt element-1" data-phrase-id="sentStatementsFullName"></span>
                      <xsl:value-of select="ns1:Statements/tp:FirstName"/>&#160;<xsl:value-of select="ns1:Statements/tp:LastName"/>
                    </p>
                  </div>
                </div>
              </section>
            </div>
          </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
